export default async ({ app, router, store, Vue,redirect }) => {
  router.beforeEach((to, from, next) => {
    
    if (to.matched.some(record => record.meta.requiresAuth)) {
      if (!store.getters['auth/isLoggedIn']) {
        redirect('/login')
      } else {
        next()
      }
    } else if (to.matched.some(record => record.meta.guestMiddleware)) {
      if (!store.getters['auth/isLoggedIn']) {
        next()
      } else {
        redirect('/qbank/dashboard/welcome')
      }
    } else {
      next()
    }
  })
}
