import axios from 'axios'
import { Cookies } from 'quasar'
const axiosInstance = axios.create({
  baseURL: 'http://interfaceedu.docexams.com/api/'
})
export default ({ Vue,ssrContext}) => {
  const cookies = process.env.SERVER
  ? Cookies.parseSSR(ssrContext)
  : Cookies 
  let token=cookies.has('auth_token') ? cookies.get('auth_token') : '';
  axiosInstance.defaults.headers.common.Authorization = 'Bearer ' + token
  Vue.prototype.$axios = axios
  if(!process.env.SERVER){
    window.axios = axiosInstance
  }
}
export { axiosInstance }
