import { QSpinnerHourglass } from 'quasar'

export const freeTrialQbank = {
    methods: {
        freeTrial: function (id) {
            if (!this.isLoggedIn) {
                this.$router.push({ name: "login" });
                return;
            }
            this.autoCreateQbankTest(id);
        },
        autoCreateQbankTest(id) {
            
            this.startLoader("creating test.Please Hang on...");
            let examId = Math.ceil(Math.random() * 10000) + new Date().getTime(); //assign Exam Id
            axios
                .post("/checkout-free-trial/" + id, {
                    examId: examId,
                })
                .then((response) => {
                    if (response.data.test_id) {
                        this.$router.push({
                            name: "qbank-test-app",
                            params: {
                                test_id: response.data.test_id,
                            },
                        });
                    } else {
                        this.$router.push({
                            name: "qbank-welcome"
                        });
                    }

                    this.stopLoader();
                })
                .catch((e) => {
                    this.stopLoader();
                    this.$q.notify({
                        message: "Request Failed",
                        type: "error-notify",
                        caption: "Sorry!! Test Creation Failed...",
                    });
                });
        },
    },
}