import { QSpinnerHourglass } from 'quasar'

export const loader = {
  methods: {
    startLoader (msg="processing") {
      /* This is for Codepen (using UMD) to work */
      const spinner = typeof QSpinnerHourglass !== 'undefined'
        ? QSpinnerHourglass // Non-UMD, imported above
        : Quasar.components.QSpinnerHourglass // eslint-disable-line
      /* End of Codepen workaround */

      this.$q.loading.show({
        spinner,
        spinnerColor: 'yellow',
        spinnerSize: 140,
        backgroundColor: 'purple',
        message: msg,
        messageColor: 'black'
      });
      this.timer=true;
    },
    stopLoader(){
        this.$q.loading.hide();
        this.timer=false;
    }
  },

  beforeDestroy () {
    if (this.timer) {
      clearTimeout(this.timer)
      this.$q.loading.hide()
    }
  }
}