
const routes = [
  {
    path: '/',
    component: () => import('layouts/MainLayout.vue'),
    children: [
      { path: '', component: () => import('pages/HomePage.vue') },
      {
        path: 'login',
        component: () => import('pages/Login.vue'),
        name: 'login',
        meta: {
          guestMiddleware: true
        }
      },
      { path: 'register', component: () => import('pages/Register.vue') },
      { path: '/qbank/:slug', component: () => import('pages/QbankDetails.vue'),props: true ,name: 'qbank-details'},
      { path: '/cart', component: () => import('pages/Cart.vue'),props: true ,name: 'cart'},
      {path: '/find-medical-qbank', component: () => import('pages/SearchQbank.vue') ,name:'qbank-search'},
      {path: '/medical-exams', component: () => import('pages/MedicalExams.vue') ,name:'medical-exams'},
      {path: '/medical-exams/:slug', component: () => import('pages/MedicalPage.vue'),props: true ,name:'medical-page'},
      {path: '/testimonials', component: () => import('pages/Testimonial.vue') ,name:'testimonials'},
      {
        path: '/:slug', component: () => import('pages/ContentPage.vue') ,props: true,name:'pages',
        alias: [
                '/teacher/:slug',
                '/institution/:slug',
                '/medical/:slug',
                '/medical/haad/:slug',
                '/students/:slug',
                '/students/UK-Higher-Education/:slug',
                '/tests/businesstest/:slug','/tests/cgfns/:slug','/tests/computertest/:slug','/tests/css/:slug','/tests/dha/:slug',
                '/tests/englishtests/:slug','/tests/fcps/:slug','/tests/gmat/:slug','/tests/gre/:slug','/tests/ielts/:slug',
                '/tests/iqtests/:slug','/tests/issb/:slug','/tests/maketest/:slug','/tests/mcps/:slug','/tests/medicaltest/:slug',
                '/tests/moh/:slug','/tests/plab/:slug','/tests/sat/:slug','/tests/schooltest/:slug','/tests/toefl/:slug',
                '/tests/usmle/:slug',
                '/students/April/:slug','/students/April-08/:slug','/students/April-09/:slug','/students/April-10/:slug','/students/April-11/:slug',
                '/students/April-12/:slug','/students/April-13/:slug','/students/April-14/:slug',
                '/students/Aug/:slug','/students/Aug-07/:slug','/students/Aug-08/:slug','/students/Aug-09/:slug','/students/Aug-10/:slug',
                '/students/Aug-11/:slug','/students/Aug-12/:slug','/students/Aug-13/:slug','/students/Aug-14/:slug',
                '/students/Dec/:slug','/students/Dec-07/:slug','/students/Dec-08/:slug','/students/Dec-09/:slug','/students/Dec-10/:slug',
                '/students/Dec-11/:slug','/students/Dec-12/:slug','/students/Dec-13/:slug',
                '/students/Feb/:slug','/students/Feb-08/:slug','/students/Feb-09/:slug','/students/Feb-10/:slug',
                '/students/Feb-11/:slug','/students/Feb-12/:slug','/students/Feb-13/:slug','/students/Feb-14/:slug',
                '/students/Jan/:slug','/students/Jan-08/:slug','/students/Jan-09/:slug','/students/Jan-10/:slug',
                '/students/Jan-11/:slug','/students/Jan-12/:slug','/students/Jan-13/:slug','/students/Jan-14/:slug',
                '/students/July/:slug','/students/July-08/:slug','/students/July-09/:slug','/students/July-10/:slug',
                '/students/July-11/:slug','/students/July-12/:slug','/students/July-13/:slug','/students/July-14/:slug',
                '/students/June/:slug','/students/June-08/:slug','/students/June-09/:slug','/students/June-10/:slug',
                '/students/June-11/:slug','/students/June-12/:slug','/students/June-13/:slug','/students/June-14/:slug',
                '/students/March/:slug','/students/March-08/:slug','/students/March-09/:slug','/students/March-10/:slug',
                '/students/March-11/:slug','/students/March-12/:slug','/students/March-13/:slug','/students/March-14/:slug',
                '/students/May/:slug','/students/May-08/:slug','/students/May-09/:slug','/students/May-10/:slug',
                '/students/May-11/:slug','/students/May-12/:slug','/students/May-13/:slug','/students/May-14/:slug',
                '/students/Nov/:slug','/students/Nov-07/:slug','/students/Nov-08/:slug','/students/Nov-09/:slug','/students/Nov-10/:slug',
                '/students/Nov-11/:slug','/students/Nov-12/:slug','/students/Nov-13/:slug',
                '/students/Oct/:slug','/students/Oct-07/:slug','/students/Oct-08/:slug','/students/Oct-09/:slug','/students/Oct-10/:slug',
                '/students/Oct-11/:slug','/students/Oct-12/:slug','/students/Oct-13/:slug','/students/Oct-14/:slug',
                '/students/Sep/:slug','/students/Sep-07/:slug','/students/Sep-08/:slug','/students/Sep-09/:slug','/students/Sep-10/:slug',
                '/students/Sep-11/:slug','/students/Sep-12/:slug','/students/Sep-13/:slug','/students/Sep-14/:slug',
                
               ] 
      }
    ]
  },
  {
    path: '/qbank', component: () => import('layouts/DashboardQbank.vue'), 
    children: [

      { path: '/qbank/dashboard/welcome', component: () => import('pages/qbank/Welcome.vue'), name: 'qbank-welcome' },
      { path: '/qbank/dashboard/view/tests', component: () => import('pages/qbank/AllTest.vue'), name: 'qbank-all-tests' },
      { path: '/qbank/dashboard/test/analysis/:id', component: () => import('pages/qbank/TestAnalysis.vue'), name: 'app-test-analysis' },
      { path: '/qbank/dashboard/create/test', component: () => import('pages/qbank/CreateTest.vue'), name: 'qbank-create-test' },
      { path: '/qbank/dashboard/reports', component: () => import('pages/qbank/TestReport.vue'), name: 'qbank-reports' },
      { path: '/qbank/dashboard/profile', component: () => import('pages/qbank/Profile.vue'), name: 'qbank-profile' },
    ],
    meta: {
      requiresAuth: true
    }
  },
  {
    path: '/test/app/qbank/:test_id/:question_index?',  component: () => import('pages/qbank/app/TestApp.vue') ,name:'qbank-test-app',props:true,
    meta: {
        requiresAuth: true
    },
  },
  {
  path: '*',component: () => import('pages/Error404.vue'),name:'notFound'
  }
]

// Always leave this as last one
if (process.env.MODE !== 'ssr') {
  routes.push({
    path: '*',
    component: () => import('pages/Error404.vue')
  })
}

export default routes
