
export function isLoggedIn(state) {
  return Object.keys(state.user).length > 0
}
export function isTutor(state) {
  return state.user.tutor ? true : false;
}

export function hasCourse(state) {
  return state.user.total_courses > 0 ? true : false;
}
export function getCoursesCount(state) {
  return state.user.total_courses;
}
export function hasQbank(state) {
  return state.user.total_qbanks > 0 ? true : false;
}
export function getQbanksCount(state) {
  return state.user.total_qbanks;
}
export function hasCourseRequests(state) {
  return state.user.total_courses_requests > 0 ? true : false;
}
export function getCoursesRequestsCount(state) {
  return state.user.total_courses_requests;
}

export function authUser(state) {
  return state.user;
}
export function authUserName(state) {
  return state.user.fname + " "+state.user.lname;
}
export function authUserImageUrl(state) {
  if (state.user.provider && state.user.avatar) {
    return state.user.avatar;
  } else {
    if (state.user.image) {
      return 'http://interfaceedu.docexams.com/storage/user/s/' + state.user.image;
    }
    return 'http://interfaceedu.docexams.com/storage/user/s/default.png';
  }
}
export function authUserImageUrlMediumSize(state) {
  if (state.user.provider && state.user.avatar) {
    return state.user.avatar;
  } else {
    if (state.user.image) {
      return 'http://interfaceedu.docexams.com/storage/user/m/' + state.user.image;
    }
    return 'http://interfaceedu.docexams.com/storage/user/m/default.png';
  }
}