import { Cookies } from 'quasar'
export function UPDATE_IMAGE (state,image) {
  state.user.image=image
}
export function AUTH_REQUEST (state, data) {
  state.status = 'loading'
}
export function AUTH_SUCCESS (state, data) {
  state.status = 'success'
  state.token = data.token
  state.user = data.user
  
  Cookies.set('auth_token',state.token);
  window.axios.defaults.headers.common.Authorization = 'Bearer ' + state.token
}
export function AUTH_SUCCESS_SSR (state, data) {
  state.status = 'success'
  state.user = data.user
}
export function AUTH_ERROR (state) {
  state.status = 'error'
}
export function SET_AUTH_TOKEN (state) {
  window.axios.defaults.headers.common.Authorization = 'Bearer ' + state.token
}

export function AUTH_LOGOUT (state) {
  state.status = ''
  state.token = ''
  state.user = {}
  delete window.axios.defaults.headers.common.Authorization
  Cookies.remove('auth_token');
}

