import { LocalStorage } from 'quasar'
export function add(state, product) {
    state.cart.push(product);
    LocalStorage.set('cart',state.cart);
}
export function remove(state, index) {
    state.cart.splice(index, 1);
    LocalStorage.set('cart',state.cart);
}
export function update(state, item) {

    state.cart[item.index].price = item.actual_price;
    state.cart[item.index].discount = item.discount_price
    state.cart[item.index].plan = item.plan
    LocalStorage.set('cart',state.cart);
}
export function updateCurrencyAndRate(state, conversion) {

    state.rate = conversion.rate;
    state.currency=conversion.currency
}
export function clear(state) {
    state.cart = [];
    LocalStorage.remove('cart');
}
export function initCart(state) {
    state.cart=LocalStorage.has('cart') ? LocalStorage.getItem('cart') : [];
}

