import Vue from 'vue'
import Vuex from 'vuex'
import auth from './auth'
import cart from './cart'
import sidebar from './sidebar'

Vue.use(Vuex)

/*
 * If not building with SSR mode, you can
 * directly export the Store instantiation;
 *
 * The function below can be async too; either use
 * async/await or return a Promise which resolves
 * with the Store instance.
 */

export default function ({ ssrContext }) {
  // const ls = process.env.SERVER ? undefined : new SecureLS({ isCompression: false })
  const Store = new Vuex.Store({
    modules: {
      auth,
      cart,
      sidebar
    },

    // enable strict mode (adds overhead!)
    // for dev mode only
    strict: process.env.DEV
  })

  return Store
}
